
#ifndef _1_CRYS_SEP_ATP_RSA_Acceptance_h_H
#define _1_CRYS_SEP_ATP_RSA_Acceptance_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS.h"
#include "CRYS_SEP_ATP_Defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 12 12:56:19 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_SEP_ATP_RSA_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/******** Defines **********/
/******** Enums ************/
/******** Typedefs  **********/

typedef struct SEP_RSA_TestGetKeyDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t					TST_PrivetExponent_D[TST_MAX_PRVT_EXP_SIZE_IN_BYTES];
	DxUint16_t					TST_PrivExponentSize; 
	DxUint8_t					TST_PublicExponent_E[TST_MAX_PUB_EXP_SIZE_IN_BYTES];
	DxUint16_t					TST_PubExponentSize; 
	DxUint8_t					TST_Modulus_N[TST_MAX_MOD_SIZE_IN_BYTES];
	DxUint16_t					TST_ModulusSize;
	DxUint8_t					TST_P[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint16_t					TST_pSize; 
	DxUint8_t					TST_Q[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];  	   
	DxUint16_t					TST_qSize; 
	DxUint8_t					TST_Dp[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint16_t					TST_DpSize; 
	DxUint8_t					TST_Dq[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];
	DxUint16_t					TST_DqSize; 
	DxUint8_t					TST_Qinv[TST_MAX_PRVT_EXP_SIZE_IN_BYTES/2];		  	
	DxUint16_t					TST_QinvSize; 
} SEP_RSA_TestGetKeyDataStruct;

/******** Structs  **********/

/******** Public Variables ********/
/******** Public Functions ********/
/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PRIME_EncDec         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* CRT_Mode - mode of the private key
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes RSA primitive encryption/decryption process
* Algorithm:   
* 1. Allocate memory buffers
* 2. Build the Public Key from External exponent and modulus
* 3. Build the Private Key from external exponent and modulus
* 4. Encrypt a known vector
* 5. Compare the outputted result to the expected one                                                   
* 6. Decrypt the encrypted output
* 7. Compare the outputted result to the original text
* 6. Free allocated buffers
*
**************************************************************************************/                                
CRYSError_t SEPQA_RSA_PRIME_EncDec (DxUint8_t	*PubExponent_ptr,
								DxUint16_t	 PubExponentSize,
								DxUint8_t   *PrivExponent_ptr,
								DxUint16_t   PrivExponentSize,
								DxUint8_t	*Modulus_ptr,
								DxUint16_t	 KeySize,
								DxUint8_t    CRT_Mode,
								DxUint8_t   *P_ptr, 
								DxUint16_t	 PSize,
								DxUint8_t   *Q_ptr,
								DxUint16_t   QSize,
								DxUint8_t   *dP_ptr, 
								DxUint16_t   dPSize,
								DxUint8_t   *dQ_ptr,
								DxUint16_t   dQSize,
								DxUint8_t   *qInv_ptr,
								DxUint16_t   qInvSize,
								DxUint8_t   *Data_ptr,
								DxUint16_t   DataSize,
								DxUint8_t   *ExpectedData_ptr,
								DxUint8_t   *FailureFunctionNameOut);


/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PRIME_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* CRT_Mode - mode of the private key
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
* Description:                                                                 
*  This function Is a Acceptance test for RSA primitive Sign & Verify                  
*  This function signs and verifies known vectors using RSA primitives
*  Vector/Keys sizes used (in bits) - 2048                                                        
*  This also outputs the results to an output buffer or the same input buffer
* Algorithm:   
* 1. Allocate memory buffers
* 2. Build the Private Key from external exponent and modulus
* 3. Build the Public Key from External exponent and modulus
* 4. sign/verify a known vector
* 5. Compare the outputted result to the expected one
* 6. Free allocated buffers
*
**************************************************************************************/

CRYSError_t SEPQA_RSA_PRIME_SignVerify (DxUint8_t	*PubExponent_ptr,
										DxUint16_t	 PubExponentSize,
										DxUint8_t   *PrivExponent_ptr,
										DxUint8_t	*Modulus_ptr,
										DxUint16_t	 KeySize,
										DxUint8_t    CRT_Mode,
										DxUint8_t   *P_ptr, 
										DxUint16_t	 PSize,
										DxUint8_t   *Q_ptr,
										DxUint16_t   QSize,
										DxUint8_t   *dP_ptr, 
										DxUint16_t   dPSize,
										DxUint8_t   *dQ_ptr,
										DxUint16_t   dQSize,
										DxUint8_t   *qInv_ptr,
										DxUint16_t   qInvSize,
										DxUint8_t   *Data_ptr,
										DxUint16_t   DataSize,
										DxUint8_t   *ExpectedData_ptr,
										DxUint8_t   *FailureFunctionNameOut);

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PKCS1v15_EncDec         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* CRT_Mode - mode of the private key
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
* Description:
* This function is qa external application on the SEP, that executes
* RSA PKCS1v15 encrypt and decrypt according to PKCS#1 Ver1.5
* Algorithm:   
* 1. Allocate memory buffers
* 2. Prepare keys 
*    a. Generate keys 
*    or
*    a. Build the Private Key from external exponent and modulus
*    b. Build the Public Key from External exponent and modulus
* 3. Encrypt a known vector
* 5. Decrypt the data using the PKCS1v15 
* 6. Compare the outputted result to the input one                  
* 7. Free allocated buffers
*
**************************************************************************************/                                
CRYSError_t SEPQA_RSA_PKCS1v15_EncDec (DxUint8_t	*PubExponent_ptr,
									   DxUint16_t	 PubExponentSize,
									   DxUint8_t   *PrivExponent_ptr,
									   DxUint16_t   PrivExponentSize,
									   DxUint8_t	*Modulus_ptr,
									   DxUint16_t	 KeySize,
									   DxUint16_t   KeyGenType,
									   DxUint8_t    CRT_Mode,
									   DxUint8_t   *P_ptr, 
									   DxUint16_t	 PSize,
									   DxUint8_t   *Q_ptr,
									   DxUint16_t   QSize,
									   DxUint8_t   *dP_ptr, 
									   DxUint16_t   dPSize,
									   DxUint8_t   *dQ_ptr,
									   DxUint16_t   dQSize,
									   DxUint8_t   *qInv_ptr,
									   DxUint16_t   qInvSize,
									   DxUint8_t   *Data_ptr,
									   DxUint16_t   DataSize,
									   DxUint8_t   *FailureFunctionNameOut);

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PKCS1v15_NonIntegrate_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes acceptance non integrated test for RSA PKCS1v15 Sign & Verify
* Algorithm:   
* 1. Allocate memory buffers       
* 2. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus
* 3. Call the CRYS_RSA_PKCS1v15_SignInit to init the Sign operation
* 4. Call the CRYS_RSA_PKCS1v15_SignUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
* 5. Call the RSA_SignFinish to complete the sign operation
* 6. Call the CRYS_RSA_PKCS1v15_VerifyInit to init the verification operation
* 7. Call the CRYS_RSA_PKCS1v15_VerifyUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
* 8.Call the CRYS_RSA_PKCS1v15_VerifyFinish to complete the verification operation            * 6. Free allocated buffers
* 9. Free allocated buffers
*
**************************************************************************************/                                
CRYSError_t SEPQA_RSA_PKCS1v15_NonIntegrate_SignVerify(
									DxUint8_t	*PubExponent_ptr,
									DxUint16_t	 PubExponentSize,
									DxUint8_t   *PrivExponent_ptr,
									DxUint16_t   PrivExponentSize,
									DxUint8_t	*Modulus_ptr,
									DxUint16_t	 KeySize,
									DxUint8_t    CRT_Mode,
									DxUint8_t    KeyGenType,
									CRYS_RSA_HASH_OpMode_t hashMode,
									DxUint8_t   *P_ptr, 
									DxUint16_t	 PSize,
									DxUint8_t   *Q_ptr,
									DxUint16_t   QSize,
									DxUint8_t   *dP_ptr, 
									DxUint16_t   dPSize,
									DxUint8_t   *dQ_ptr,
									DxUint16_t   dQSize,
									DxUint8_t   *qInv_ptr,
									DxUint16_t   qInvSize,
									DxUint8_t   *Data_ptr,
									DxUint16_t   DataSize,
									DxUint8_t   *FailureFunctionNameOut);

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PKCS1v15_Integrate_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes acceptance non integrated test for RSA PKCS1v15 Sign & Verify
* Algorithm:   
* 1. Allocate memory buffers       
* 2. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus
* 3. Call the CRYS_RSA_PKCS1v15_SignInit to init the Sign operation
* 4. Call the CRYS_RSA_PKCS1v15_SignUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
* 5. Call the RSA_SignFinish to complete the sign operation
* 6. Call the CRYS_RSA_PKCS1v15_VerifyInit to init the verification operation
* 7. Call the CRYS_RSA_PKCS1v15_VerifyUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
* 8.Call the CRYS_RSA_PKCS1v15_VerifyFinish to complete the verification operation            * 6. Free allocated buffers
* 9. Free allocated buffers
*
**************************************************************************************/                                
CRYSError_t SEPQA_RSA_PKCS1v15_Integrate_SignVerify(
								DxUint8_t	*PubExponent_ptr,
								DxUint16_t	 PubExponentSize,
								DxUint8_t   *PrivExponent_ptr,
								DxUint16_t   PrivExponentSize,
								DxUint8_t	*Modulus_ptr,
								DxUint16_t	 KeySize,
								DxUint8_t    CRT_Mode,
								DxUint8_t    KeyGenType,
								CRYS_RSA_HASH_OpMode_t hashMode,
								DxUint8_t   *P_ptr, 
								DxUint16_t	 PSize,
								DxUint8_t   *Q_ptr,
								DxUint16_t   QSize,
								DxUint8_t   *dP_ptr, 
								DxUint16_t   dPSize,
								DxUint8_t   *dQ_ptr,
								DxUint16_t   dQSize,
								DxUint8_t   *qInv_ptr,
								DxUint16_t   qInvSize,
								DxUint8_t   *Data_ptr,
								DxUint16_t   DataSize,
								DxUint8_t   *FailureFunctionNameOut);

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_OAEP_EncDec         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes acceptance test for RSA OAEP encrypt and decrypt
* according to PKCS#1 Ver2.1
* Algorithm:   
* 1. Allocate memory buffers       
* 2. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus       
* 3. Encrypt a known vector
* 4. Decrypt the output of the previous step
* 5. Compare the outputted result to the input one                  
* 6. Free allocated buffers
*
**************************************************************************************/                                
CRYSError_t SEPQA_RSA_OAEP_EncDec(
								  DxUint8_t	*PubExponent_ptr,
								  DxUint16_t	 PubExponentSize,
								  DxUint8_t   *PrivExponent_ptr,
								  DxUint16_t   PrivExponentSize,
								  DxUint8_t	*Modulus_ptr,
								  DxUint16_t	 KeySize,
								  DxUint8_t    CRT_Mode,
								  DxUint8_t    KeyGenType,
								  CRYS_RSA_HASH_OpMode_t hashMode,
								  DxUint8_t   *P_ptr, 
								  DxUint16_t	 PSize,
								  DxUint8_t   *Q_ptr,
								  DxUint16_t   QSize,
								  DxUint8_t   *dP_ptr, 
								  DxUint16_t   dPSize,
								  DxUint8_t   *dQ_ptr,
								  DxUint16_t   dQSize,
								  DxUint8_t   *qInv_ptr,
								  DxUint16_t   qInvSize,
								  DxUint8_t   *Data_ptr,
								  DxUint16_t   DataSize,
								  DxUint8_t   *FailureFunctionNameOut);

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PSS_NonIntegrate_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes acceptance test for RSA PSS PKCS#1v2.1 sign & Verify
* Algorithm:   
* 1. Allocate memory buffers       
* 2. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus   
* 3. Call the CRYS_RSA_PSS_SignInit to init the Sign operation
* 4. Call the CRYS_RSA_PSS_SignUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
* 5. Call the RSA_SignFinish to complete the sign operation
* 6. Call the CRYS_RSA_PSS_VerifyInit to init the verification operation
* 7. Call the CRYS_RSA_PSS_VerifyUpdate - This function is called N times
*                                        (N = number of blocks in data each block is 16byte)
* 8.Call the CRYS_RSA_PSS_VerifyFinish to complete the verification operation             
* 9. Free allocated buffers
*
**************************************************************************************/                                
CRYSError_t SEPQA_RSA_PSS_NonIntegrate_SignVerify(
				DxUint8_t	           *PubExponent_ptr,
				DxUint16_t	            PubExponentSize,
				DxUint8_t              *PrivExponent_ptr,
				DxUint16_t              PrivExponentSize,
				DxUint8_t	           *Modulus_ptr,
				DxUint16_t	            KeySize,
				DxUint8_t               CRT_Mode,
				DxUint8_t				KeyGenType,
				CRYS_RSA_HASH_OpMode_t  HashMode,
				DxUint16_t		        SaltLength,
				DxUint8_t              *P_ptr, 
				DxUint16_t	            PSize,
				DxUint8_t              *Q_ptr,
				DxUint16_t              QSize,
				DxUint8_t              *dP_ptr, 
				DxUint16_t              dPSize,
				DxUint8_t              *dQ_ptr,
				DxUint16_t              dQSize,
				DxUint8_t              *qInv_ptr,
				DxUint16_t              qInvSize,
				DxUint8_t              *Data_ptr,
				DxUint16_t              DataSize,
				DxUint8_t              *FailureFunctionNameOut);

/***********************************************************************
* Function Name:                                                           
*  SEPQA_RSA_PSS_Integrate_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
* This function is qa external application on the SEP, 
* that executes acceptance test for RSA PSS PKCS#1v2.1 sign & Verify
* Algorithm:   
* 1. Allocate memory buffers       
* 2. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus   
* 3. Preform the Sign operation
* 4. Perform the Verify operation
* 9. Free allocated buffers
*
**************************************************************************************/                                
CRYSError_t SEPQA_RSA_PSS_Integrate_SignVerify(
					DxUint8_t	            *PubExponent_ptr,
					DxUint16_t				PubExponentSize,
					DxUint8_t				*PrivExponent_ptr,
					DxUint16_t				PrivExponentSize,
					DxUint8_t	            *Modulus_ptr,
					DxUint16_t				KeySize,
					DxUint8_t				CRT_Mode,
					DxUint8_t				KeyGenType,
					CRYS_RSA_HASH_OpMode_t	HashMode,
					DxUint16_t				SaltLength,
					DxUint8_t				*P_ptr, 
					DxUint16_t				PSize,
					DxUint8_t				*Q_ptr,
					DxUint16_t				QSize,
					DxUint8_t				*dP_ptr, 
					DxUint16_t				dPSize,
					DxUint8_t				*dQ_ptr,
					DxUint16_t				dQSize,
					DxUint8_t				*qInv_ptr,
					DxUint16_t				qInvSize,
					DxUint8_t				*Data_ptr,
					DxUint16_t				DataSize,
					DxUint8_t				*FailureFunctionNameOut);


/***************************
* Function Name:                                                           
*  SEPQA_RSA_PKCS1v15_ExternalHash_SignVerify        
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify
*  When the Hash for the Sign is preformed externally                   
*  This function Signs & Verifies hash vectors using RSA PKCS1v15
*  Vectors sizes used (in byte) - SHA1 - 20, MD5 - 16                                                      
*  Key sizes used     (in bits) - 512/1024/2048
* Algorithm:       
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus
*  2. Call the CRYS_RSA_PKCS1v15_SHA1_Sign or CRYS_RSA_PKCS1v15_MD5_Sign to preform the Sign operation
*  3. Call the CRYS_RSA_PKCS1v15_SHA1_Verify or CRYS_RSA_PKCS1v15_MD5_verify to complete the verification operation
*  4. Compare the outputted result to the expected one                  
*
**************************/
CRYSError_t SEPQA_RSA_PKCS1v15_ExternalHash_SignVerify(DxUint8_t	 *PubExponent_ptr,
													   DxUint16_t	 PubExponentSize,
													   DxUint8_t     *PrivExponent_ptr,
													   DxUint8_t	 *Modulus_ptr,
													   DxUint16_t	 KeySize,
													   DxUint8_t     CRT_Mode,
													   DxUint8_t     KeyGenType,
													   CRYS_RSA_HASH_OpMode_t hashMode,
													   DxUint8_t     *P_ptr, 
													   DxUint16_t	 PSize,
													   DxUint8_t     *Q_ptr,
													   DxUint16_t    QSize,
													   DxUint8_t     *dP_ptr, 
													   DxUint16_t    dPSize,
													   DxUint8_t     *dQ_ptr,
													   DxUint16_t    dQSize,
													   DxUint8_t     *qInv_ptr,
													   DxUint16_t    qInvSize,
													   DxUint8_t     *Data_ptr,
													   DxUint16_t    DataSize,
													   DxUint8_t     *FailureFunctionNameOut);


/***************************
* Function Name:                                                           
*  SEPQA_RSA_PSS_ExternalHash_SignVerify         
* 
* Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* KeyGenType - key gen type (internal/external)
* CRT_Mode - mode of the private key
* hashMode - hash mode
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
*  dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RSA PKCS1v2.1 PSS Sign & Verify
*  When the Hash for the Sign is preformed externally                   
*  This function Signs & Verifies hash vectors using RSA PKCS1v2.1 PSS                                                   
*  Key sizes used     (in bits) - 512/1024/2048
* Algorithm:       
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus 
*  2. Call the CRYS_RSA_PSS_SHA1_Sign or CRYS_RSA_PSS_MD5_Sign to preform the Sign operation
*  3. Call the CRYS_RSA_PSS_SHA1_Verify or CRYS_RSA_PSS_MD5_verify to complete the verification operation
*  4. Compare the outputted result to the expected one                  
*
**************************/
CRYSError_t SEPQA_RSA_PSS_ExternalHash_SignVerify(	DxUint8_t	          *PubExponent_ptr,
													DxUint16_t	           PubExponentSize,
													DxUint8_t             *PrivExponent_ptr,
													DxUint8_t	          *Modulus_ptr,
													DxUint16_t	           KeySize,
													DxUint8_t              CRT_Mode,
													DxUint8_t			   KeyGenType,
													CRYS_RSA_HASH_OpMode_t HashMode,
													DxUint16_t		       SaltLength,
													DxUint8_t             *P_ptr, 
													DxUint16_t	           PSize,
													DxUint8_t             *Q_ptr,
													DxUint16_t             QSize,
													DxUint8_t             *dP_ptr, 
													DxUint16_t             dPSize,
													DxUint8_t             *dQ_ptr,
													DxUint16_t             dQSize,
													DxUint8_t             *qInv_ptr,
													DxUint16_t             qInvSize,
													DxUint8_t             *Data_ptr,
													DxUint16_t             DataSize,
													DxUint8_t             *FailureFunctionNameOut);



/***************************
* Function Name:                                                           
*  SEPQA_RSA_Get_PrivAndPubKey      
* 
*Inputs:
* PubExponent_ptr - a pointer to the exponent stream of bytes ( Big endian ).
* PubExponentSize - The size of the exponent in bytes.  
* Modulus_ptr  - a pointer to the modulus stream of bytes ( Big endian ) the MS bit must be set to '1'.
* KeySize (ModulusSize)  - The size of the modulus in bytes.
* CRT_Mode - mode of the private key
* P_ptr - A pointer to the first factor stream of bytes (Big-Endian format)
* PSize - The size of the first factor, in bytes.
* Q_ptr - A pointer to the second factor stream of bytes (Big-Endian format)
* QSize - The size of the second factor, in bytes.
* dP_ptr - A pointer to the first factor's CRT exponent stream of bytes (Big-Endian format)
* dPSize - The size of the first factor's CRT exponent, in bytes.
* dQ_ptr - A pointer to the second factor's CRT exponent stream of bytes (Big-Endian format)
* dQSize - The size of the second factor's CRT exponent, in bytes.
* qInv_ptr - A pointer to the first CRT coefficient stream of bytes (Big-Endian format)
* qInvSize - The size of the first CRT coefficient, in bytes.
* 
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is an Acceptance test for RSA Get Privet Key and Get Public Key                  
*  This function Generate a RSA key and get its privet\public key and
*  compare it to the test vector
*
*  Key sizes used     (in bits) - 2048
*  This also outputs the results to an output buffer or the same input buffer
* Algorithm:       
*  1. Prepare keys 
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus
*  3. Call the CRYS_RSA_Get_Privet_key to preform the Get operation
*  4. Call the CRYS_RSA_Get_Public_key to preform the Get operation
*  5. Compare the outputted result to the expected one                  
*
**************************/
CRYSError_t SEPQA_RSA_Get_PrivAndPubKey(DxUint8_t	          *PubExponent_ptr,
										DxUint16_t	           PubExponentSize,
									    DxUint8_t             *PrivExponent_ptr,
									    DxUint16_t             PrivExponentSize,
									    DxUint8_t	          *Modulus_ptr,
									    DxUint16_t	           KeySize,
									    DxUint8_t              CRT_Mode,
									    DxUint8_t             *P_ptr, 
									    DxUint16_t	           PSize,
									    DxUint8_t             *Q_ptr,
									    DxUint16_t             QSize,
									    DxUint8_t             *dP_ptr, 
									    DxUint16_t             dPSize,
									    DxUint8_t             *dQ_ptr,
									    DxUint16_t             dQSize,
									    DxUint8_t             *qInv_ptr,
									    DxUint16_t             qInvSize,
									    DxUint8_t             *FailureFunctionNameOut);

#ifdef __cplusplus
}
#endif

#endif


